<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Handyman</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
        integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
     <!-- Bootstrap CSS -->
     <link href="{{ asset('front/css/bootstrap.min.css') }}" rel="stylesheet">
     <link rel="icon" href="{{ getFaviconUrl() }}" type="image/png">

     {{-- css link --}}
     <link rel="stylesheet" href="{{ asset('assets/css/vcard31.css') }}">
     <link rel="stylesheet" href="{{ asset('assets/css/slider/css/slick.css') }}">
     <link rel="stylesheet" href="{{ asset('assets/css/slider/css/slick-theme.min.css') }}">
     <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/slick-theme.css') }}">
     <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/slick.css') }}">
     <link rel="stylesheet" href="{{ asset('assets/css/new_vcard/custom.css') }}">
     <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/third-party.css') }}">
     <link rel="stylesheet" type="text/css" href="{{ asset('css/plugins.css') }}">
     <link rel="stylesheet" href="{{ asset('assets/css/custom-vcard.css') }}">
     <link rel="stylesheet" href="{{ asset('assets/css/lightbox.css') }}">
</head>

<body>
    <div class="container p-0">
        <div class="main-content mx-auto w-100 overflow-hidden">
            <div class="banner-section position-relative">
                <div class="banner-img"></div>
            </div>
            <div class="d-flex justify-content-end position-absolute top-0 end-0 me-3">
                <div class="language pt-3 me-2">
                    <ul class="text-decoration-none">
                        <li class="dropdown1 dropdown lang-list">
                            <a class="dropdown-toggle lang-head text-decoration-none" data-toggle="dropdown"
                                role="button" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-language me-2"></i>Language</a>
                            <ul class="dropdown-menu start-0 lang-hover-list top-100 mt-0">
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/english.png') }}" width="25px"
                                        height="20px" class="me-3" loading="lazy"><a href="#">English</a>
                                </li>
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/spain.png') }}" width="25px"
                                        height="20px" class="me-3" loading="lazy"><a href="#">Spanish</a>
                                </li>
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/france.png') }}" width="25px"
                                        height="20px" class="me-3" loading="lazy"><a href="#">Franch</a>
                                </li>
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/arabic.svg') }}" width="25px"
                                        height="20px" class="me-3" loading="lazy"><a href="#">Arabic</a>
                                </li>
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/german.png') }}" width="25px"
                                        height="20px" class="me-3" loading="lazy"><a href="#">German</a>
                                </li>
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/russian.jpeg') }}" width="25px"
                                        height="20px" class="me-3" loading="lazy"><a href="#">russian</a>
                                </li>
                                <li>
                                    <img src="{{ asset('assets/img/vcard1/turkish.png') }}" width="25px"
                                        height="20px" class="me-3" loading="lazy"><a href="#">Turkish</a>
                                </li>

                            </ul>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="overlay"></div>
            <div class="profile-section px-30 mb-1">
                <div class="profile-bg-img text-sm-start text-end">
                    <img src="{{ asset('assets/img/vcard31/profile-bg-img.png') }}" loading="lazy" alt="profile-bg" />
                </div>

                <div class="card d-flex flex-sm-row">
                    <div class="card-img">
                        <img src="{{ asset('assets/img/vcard31/profile-img.png') }}" class="w-100 h-100 object-fit-cover" />
                    </div>
                    <div class="card-body bg-light">
                        <div class="profile-name">
                            <h4 class="text-secondary mb-0">Markush Stene</h4>
                            <p class="text-primary">Handyman</p>
                            <p class="fs-14 text-gray-100 mb-3">
                                Lorem Ipsum has been the industry's standard dummy text ever
                                since the 1500s, when an unknown printer took a galley of type
                                and scrambled it to make a type specimen book.
                            </p>
                        </div>
                        <div class="social-media d-flex flex-wrap">
                            <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                <svg width="10" height="18" viewBox="0 0 10 18" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M2.79059 11.2889C2.34698 11.2889 1.93968 11.2889 1.53237 11.2889C1.18499 11.2889 0.837601 11.2954 0.49082 11.2863C0.127698 11.2772 0.00907804 11.1596 0.00605203 10.7711C-0.00181561 9.753 -0.00242081 8.73429 0.00665723 7.71622C0.0102885 7.33094 0.137381 7.20882 0.495661 7.20621C1.16744 7.20164 1.83921 7.20491 2.51159 7.20491C2.5939 7.20491 2.67621 7.20491 2.79059 7.20491C2.79059 7.09455 2.78938 6.99986 2.79059 6.90582C2.80633 5.97788 2.77365 5.04601 2.84748 4.12329C3.03449 1.77307 4.69698 0.0947997 6.88297 0.0183961C7.77262 -0.012949 8.66469 0.0046826 9.55494 0.00729469C9.86844 0.00794771 9.99553 0.146388 9.99674 0.48596C10.001 1.43872 10.001 2.39213 9.99735 3.34489C9.99614 3.70993 9.87752 3.84249 9.52953 3.85098C8.91827 3.86666 8.30702 3.86666 7.69516 3.8771C7.00946 3.88821 6.72138 4.1775 6.70686 4.90823C6.69233 5.6468 6.70383 6.38667 6.70383 7.15397C6.80732 7.15397 6.88781 7.15397 6.96831 7.15397C7.74599 7.15397 8.52368 7.15266 9.30136 7.15462C9.79158 7.15528 9.90657 7.27805 9.90717 7.79785C9.90778 8.76694 9.90899 9.73667 9.90657 10.7058C9.90536 11.1394 9.79945 11.2563 9.39517 11.2582C8.51218 11.2621 7.62919 11.2595 6.70444 11.2595C6.70444 11.3731 6.70444 11.4744 6.70444 11.5749C6.70444 14.1243 6.70444 16.6744 6.70444 19.2238C6.70444 19.9264 6.63544 19.9996 5.97335 19.9996C5.10489 19.9996 4.23703 20.0009 3.36856 19.9989C2.90376 19.9983 2.79059 19.8775 2.79059 19.3812C2.78999 16.7906 2.78999 14.2001 2.78999 11.6102C2.79059 11.5142 2.79059 11.4182 2.79059 11.2889Z"
                                        fill="white" />
                                </svg>
                            </a>
                            <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M18 8.08246C18 8.43433 18 8.78576 18 9.13763C17.9718 9.36927 17.9488 9.60136 17.9149 9.83212C17.6401 11.6985 16.8487 13.3134 15.5237 14.6583C14.1033 16.1002 12.3817 16.9501 10.3703 17.1831C8.61161 17.387 6.93719 17.0787 5.36334 16.2591C5.25483 16.2028 5.16264 16.1808 5.03605 16.2261C4.10444 16.5599 3.16843 16.881 2.23462 17.2091C1.48916 17.4707 0.745019 17.7362 0 18C0.0154385 17.9265 0.0224961 17.8503 0.0471978 17.7798C0.598574 16.2006 1.14907 14.6205 1.70927 13.0443C1.77499 12.8598 1.77014 12.7167 1.67839 12.5379C0.832798 10.8926 0.554464 9.14555 0.825741 7.32191C1.09834 5.48901 1.89012 3.89657 3.20195 2.58333C5.14765 0.635936 7.51239 -0.205646 10.249 0.0422929C11.9124 0.192906 13.4081 0.806807 14.7138 1.85273C16.4142 3.21441 17.4777 4.96363 17.8633 7.11272C17.9206 7.43377 17.955 7.75921 18 8.08246ZM7.40873 7.10436C7.41976 7.08498 7.42152 7.07881 7.42549 7.07485C7.65266 6.84585 7.88115 6.61861 8.10655 6.38829C8.37121 6.11745 8.37121 5.82635 8.1039 5.55639C7.72015 5.16929 7.33462 4.78351 6.94645 4.40037C6.67297 4.13042 6.38493 4.13042 6.11233 4.39861C5.82826 4.67826 5.55478 4.96891 5.26366 5.24107C4.93415 5.54935 4.83623 5.92676 4.88078 6.35746C4.95533 7.07353 5.25086 7.70989 5.6161 8.31366C6.56579 9.88321 7.82557 11.159 9.35487 12.1684C9.97329 12.5766 10.6301 12.9113 11.3667 13.0602C11.9331 13.1747 12.4324 13.0932 12.8347 12.6281C13.0641 12.363 13.3301 12.1292 13.578 11.8795C13.862 11.5928 13.8616 11.3092 13.5753 11.0207C13.2119 10.6548 12.8457 10.291 12.4805 9.9268C12.1453 9.59255 11.8806 9.59167 11.5471 9.92416C11.3284 10.1426 11.1104 10.3619 10.8943 10.5786C9.32443 9.8101 8.17095 8.65805 7.40873 7.10436Z"
                                        fill="white" />
                                </svg>
                            </a>
                            <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M17.9876 10.8983C17.9818 10.0629 17.8985 9.23224 17.6556 8.42503C17.3517 7.41411 16.8008 6.60103 15.8181 6.13725C15.0589 5.77914 14.2493 5.67875 13.4221 5.70341C11.9742 5.74685 10.8026 6.30573 10.0193 7.56909C10.0105 7.58318 9.98707 7.58846 9.93778 7.61664C9.93778 7.06187 9.93778 6.53175 9.93778 6.00105C8.73333 6.00105 7.5582 6.00105 6.38601 6.00105C6.38601 10.0107 6.38601 14.0045 6.38601 18C7.62684 18 8.84773 18 10.1003 18C10.1003 17.8902 10.1003 17.8033 10.1003 17.7159C10.1003 15.8408 10.095 13.9651 10.1044 12.0901C10.1062 11.6738 10.1331 11.2547 10.1924 10.8431C10.3543 9.7148 10.9281 9.10485 11.9701 8.98156C13.1147 8.84654 13.9137 9.26394 14.1402 10.4927C14.2206 10.9294 14.2558 11.3797 14.2587 11.8241C14.2716 13.7873 14.2657 15.7504 14.2663 17.7135C14.2663 17.7981 14.2663 17.882 14.2663 17.9624C15.5277 17.9624 16.7539 17.9624 17.9912 17.9624C17.9947 17.9131 18 17.8779 18 17.8421C17.997 15.5279 18.0029 13.2131 17.9876 10.8983Z"
                                        fill="white" />
                                    <path
                                        d="M0.309402 17.9918C1.55258 17.9918 2.78403 17.9918 4.01958 17.9918C4.01958 13.9874 4.01958 9.99952 4.01958 5.99811C2.78109 5.99811 1.55493 5.99811 0.309402 5.99811C0.309402 10.0072 0.309402 13.9957 0.309402 17.9918Z"
                                        fill="white" />
                                    <path
                                        d="M2.14608 8.57462e-05C0.966266 0.0106529 -0.000586415 0.985176 2.66856e-07 2.16282C0.000586949 3.36043 0.989146 4.35139 2.176 4.34435C3.35641 4.3373 4.32443 3.3481 4.31739 2.1546C4.31094 0.956997 3.33588 -0.0104814 2.14608 8.57462e-05Z"
                                        fill="white" />
                                </svg>
                            </a>
                            <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_2075_459)">
                                        <path
                                            d="M17.998 4.14809C17.998 7.38215 17.998 10.6157 17.998 13.8497C17.927 14.1859 17.8852 14.5321 17.7801 14.8573C17.167 16.7486 15.4661 17.9896 13.4702 17.9951C10.4887 18.0033 7.50722 17.9995 4.52575 17.9962C3.56824 17.9951 2.68558 17.7304 1.91022 17.1636C0.629141 16.227 0.00070958 14.953 0.00070958 13.3677C0.00015929 10.4682 -0.00149158 7.5687 0.00346103 4.66922C0.00401132 4.37206 0.0177686 4.0694 0.0711468 3.77775C0.373256 2.11477 1.31811 0.954754 2.87873 0.319719C3.27879 0.156833 3.72398 0.103455 4.14825 0C7.38231 0 10.6158 0 13.8499 0C13.9759 0.0225619 14.1025 0.043473 14.2279 0.0671355C15.8799 0.37915 17.0366 1.31464 17.6727 2.86371C17.8395 3.26818 17.8929 3.71886 17.998 4.14809ZM16.4874 8.9989C16.4896 8.9989 16.4918 8.9989 16.494 8.9989C16.494 7.53458 16.4913 6.07026 16.4957 4.60538C16.4968 4.13599 16.434 3.68034 16.2244 3.25827C15.6565 2.11422 14.7303 1.50945 13.4498 1.50505C10.4799 1.49459 7.50998 1.50119 4.54006 1.50339C4.36506 1.50339 4.18897 1.5199 4.01618 1.54467C2.65311 1.73672 1.52446 2.96937 1.51566 4.3495C1.4953 7.41297 1.50741 10.4764 1.50575 13.5399C1.50575 13.9559 1.5872 14.3576 1.77044 14.7296C2.34605 15.8957 3.2898 16.4911 4.59233 16.4928C7.52703 16.4972 10.4617 16.495 13.3964 16.4922C13.5945 16.4922 13.7943 16.4768 13.9908 16.4498C15.3274 16.2666 16.4643 15.0202 16.4825 13.6725C16.5039 12.1152 16.4874 10.5573 16.4874 8.9989Z"
                                            fill="white" />
                                        <path
                                            d="M13.4984 9.02092C13.4748 11.5126 11.4337 13.5294 8.96844 13.497C6.47948 13.4645 4.47752 11.4389 4.50118 8.97579C4.52485 6.48298 6.56422 4.46836 9.03063 4.49973C11.5201 4.5322 13.5221 6.55782 13.4984 9.02092ZM9.00256 6.00312C7.34729 6.00037 6.01118 7.33207 6.00458 8.99175C5.99742 10.6448 7.32803 11.9837 8.98881 11.9947C10.6468 12.0051 11.9972 10.6591 11.9956 8.99725C11.9939 7.33978 10.66 6.00587 9.00256 6.00312Z"
                                            fill="white" />
                                        <path
                                            d="M13.882 5.24317C13.2558 5.24757 12.7539 4.74956 12.7539 4.12388C12.7545 3.5081 13.247 3.01009 13.8649 3.00019C14.4752 2.99028 14.9991 3.50975 14.9985 4.12443C14.9985 4.7369 14.4972 5.23877 13.882 5.24317Z"
                                            fill="white" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_2075_459">
                                            <rect width="18" height="18" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </a>
                            <a href="" class="social-icon d-flex justify-content-center align-items-center">
                                <svg width="18" height="16" viewBox="0 0 18 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M5.95486 12.4074C4.34981 12.1881 3.28492 11.3921 2.68302 9.80001C3.20004 9.80001 3.65532 9.80001 4.10288 9.80001C2.47467 9.12582 1.5564 7.94802 1.44065 6.07979C1.93451 6.226 2.38979 6.36409 2.84507 6.49405C2.86822 6.46156 2.89137 6.42907 2.91452 6.39658C2.23546 5.81986 1.74931 5.10506 1.57955 4.19531C1.40978 3.28557 1.48695 2.40831 1.95766 1.50669C3.90225 3.83791 6.27896 5.19441 9.20356 5.38936C9.20356 5.0482 9.19584 4.75578 9.20356 4.46336C9.24986 2.91192 9.97521 1.78286 11.2948 1.15741C12.5834 0.548203 13.849 0.710658 14.9601 1.66914C15.2688 1.93719 15.5466 1.99405 15.8939 1.84784C16.4263 1.62853 16.9587 1.40921 17.5375 1.18178C17.2906 1.99405 16.7813 2.5464 16.2488 3.14748C16.8044 2.99315 17.36 2.83069 17.9156 2.67636C17.9388 2.70073 17.9696 2.7251 17.9928 2.74947C17.5529 3.22871 17.1362 3.74856 16.6578 4.17907C16.3954 4.41463 16.2951 4.65019 16.2874 4.99947C16.2411 7.44441 15.5466 9.66192 14.1113 11.5951C12.1822 14.2025 9.62025 15.5184 6.46416 15.5834C4.65847 15.624 2.96854 15.226 1.37892 14.3244C1.22458 14.235 1.07025 14.1376 0.908203 13.9995C2.73704 14.0888 4.40383 13.6339 5.95486 12.4074Z"
                                        fill="white" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
                <!--
          <p class="text-gray-100 profile-desc fs-6 text-center mb-0">
            Lorem Ipsum is simply dummy text of the printing and typesetting
            industry. Lorem Ipsum has been the industry's standard dummy text
            ever since the 1500s, when an unknown printer took a galley of type
            and scrambled it to make a type specimen book.
          </p> -->
            </div>
            <div class="contact-section pt-4 px-30">
                <div class="section-heading">
                    <h2 class="mb-0">Contact</h2>
                </div>
                <div class="row">
                    <div class="col-sm-6 mb-4 pb-sm-2">
                        <div class="contact-box d-flex align-items-center">
                            <div class="contact-icon d-flex justify-content-center align-items-center me-3">
                                <svg width="27" height="20" viewBox="0 0 27 20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_671_16376)">
                                        <path
                                            d="M27 2.78896C27 2.60502 27 2.42605 27 2.24211C26.9631 2.07308 26.9367 1.90405 26.884 1.73999C26.6414 0.939597 26.1984 0.298285 25.2861 0.0894855C24.9855 0.0198857 24.6586 0.00497141 24.3475 0.00497141C17.1176 0 9.8877 0 2.65781 0C2.49961 0 2.34141 0 2.1832 0.0149142C1.7086 0.0546856 1.28672 0.223714 0.912306 0.507084C0.400782 0.894855 0.126566 1.40194 -0.00527 1.99354C-0.00527 2.19239 -0.00527 2.39125 -0.00527 2.59011C0.100199 3.09222 0.226759 3.58936 0.495705 4.04176C1.04414 4.9565 1.81406 5.66741 2.7211 6.25901C5.4 8.01889 8.07891 9.78374 10.7631 11.5387C11.2166 11.8369 11.6912 12.1054 12.1711 12.3639C13.0518 12.8362 13.9482 12.8312 14.8289 12.3589C15.2191 12.1501 15.6094 11.9413 15.9785 11.7027C18.7734 9.8782 21.5684 8.05369 24.3369 6.19935C25.6131 5.34427 26.6572 4.30524 27 2.78896Z"
                                            fill="#D94B2B" />
                                        <path
                                            d="M27 6.46783C25.36 7.9692 23.3455 8.9784 21.5209 10.2411C21.1201 10.5195 20.6982 10.7781 20.2711 11.0515C20.3186 11.1062 20.3555 11.1509 20.3924 11.1907C22.565 13.2389 24.7324 15.2822 26.8998 17.3254C26.9314 17.3552 26.9684 17.3801 27 17.4049C27 13.7609 27 10.1119 27 6.46783Z"
                                            fill="#D94B2B" />
                                        <path
                                            d="M8.53539e-05 17.4049C0.0791869 17.3353 0.158288 17.2707 0.232117 17.2011C2.33095 15.2225 4.43505 13.2439 6.53389 11.2603C6.59717 11.2006 6.65518 11.141 6.729 11.0664C6.64463 11.0067 6.5708 10.952 6.49697 10.9023C4.99931 9.93291 3.48583 8.98337 2.004 7.98908C1.3079 7.52177 0.669813 6.97492 8.53539e-05 6.46286C8.53539e-05 10.1119 8.53539e-05 13.7609 8.53539e-05 17.4049Z"
                                            fill="#D94B2B" />
                                        <path
                                            d="M8.4957 12.2347C5.94336 14.6408 3.40684 17.0321 0.854492 19.4383C1.20781 19.7564 1.64551 19.9255 2.13594 19.9801C2.27305 19.9951 2.41543 19.9951 2.55781 19.9951C9.85098 19.9951 17.1441 19.9951 24.4373 20C25.0754 20 25.6502 19.8608 26.1143 19.4731C23.5672 17.0719 21.0254 14.6756 18.4678 12.2645C17.9193 12.6324 17.3445 13.0351 16.7486 13.4129C16.0104 13.8852 15.2141 14.2481 14.3439 14.447C13.4369 14.6558 12.5773 14.4867 11.723 14.1536C10.7105 13.7609 9.85625 13.1395 8.97559 12.5529C8.81211 12.4534 8.65918 12.3441 8.4957 12.2347Z"
                                            fill="#D94B2B" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_671_16376">
                                            <rect width="27" height="20" fill="white"
                                                transform="matrix(-1 0 0 1 27 0)" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <a href="mailto:markush@gmail.com"
                                    class="text-secondary fs-6 fw-5 word-wrap">markush@gmail.com</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-4 pb-sm-2">
                        <div class="contact-box d-flex align-items-center">
                            <div class="contact-icon d-flex justify-content-center align-items-center me-3">
                                <svg width="26" height="26" viewBox="0 0 26 26" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M5.24875 11.2533C7.38447 15.3496 10.4178 18.4566 14.4261 20.5898C14.5964 20.6825 14.9988 20.5743 15.169 20.4197C16.0821 19.5541 16.9797 18.673 17.8464 17.761C18.3261 17.2509 18.8523 17.1736 19.5178 17.2973C21.0964 17.5755 22.6904 17.8537 24.2845 18.0392C25.5535 18.1938 26.0023 18.6112 26.0023 19.9096C26.0023 21.3008 26.0023 22.6766 26.0023 24.0678C26.0023 25.5672 25.5226 26.0309 23.9904 26C13.0952 25.8145 3.34518 18.0856 0.776133 7.48157C0.327324 5.61118 0.188038 3.64804 0.0177999 1.71581C-0.0905334 0.571938 0.54399 0.0154578 1.68923 0.0154578C3.2059 0 4.72256 0 6.23923 0C7.35351 0 7.8178 0.510107 7.95709 1.62307C8.17375 3.26159 8.4678 4.90012 8.77732 6.52319C8.90113 7.21879 8.77732 7.77527 8.26661 8.26992C7.24518 9.25922 6.2547 10.2485 5.24875 11.2533Z"
                                        fill="#D94B2B" />
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <a href="tel:+1 4078461474" class="text-secondary fs-6 fw-5">+1 4078461474</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 mb-sm-0 mb-4">
                        <div class="contact-box d-flex align-items-center">
                            <div class="contact-icon d-flex justify-content-center align-items-center me-3">
                                <svg width="30" height="26" viewBox="0 0 30 26" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_681_16526)">
                                        <path
                                            d="M0.390531 26C0.264533 25.7615 0.0629374 25.5355 0.0251381 25.2844C-0.0378606 24.8324 0.0251381 24.3679 -6.1387e-05 23.916C-0.0126611 23.5017 0.163735 23.2883 0.592127 23.3008C0.718124 23.3008 0.844122 23.3008 0.970119 23.3008C10.3317 23.3008 19.6807 23.3008 29.0424 23.3134C29.3574 23.3134 29.6723 23.4389 29.9873 23.5017C29.9873 24.3303 29.9873 25.1714 29.9873 26C20.1343 26 10.2561 26 0.390531 26Z"
                                            fill="#D94B2B" />
                                        <path
                                            d="M15.0315 10.6461C18.3957 10.6461 21.7598 10.6461 25.1365 10.6461C27.0391 10.6461 27.9715 11.5877 27.9841 13.4959C27.9841 13.521 27.9841 13.5336 27.9841 13.5587C28.2109 14.6635 27.6943 15.2912 26.7115 15.718C25.7161 16.1449 24.7585 16.2328 23.8892 15.492C23.4608 15.128 23.108 14.6886 22.7552 14.2492C22.289 13.6842 21.848 13.6717 21.3692 14.2241C21.0542 14.5881 20.7392 14.9522 20.3864 15.2661C19.391 16.1574 18.2949 16.2579 17.1735 15.5423C16.6695 15.2159 16.2159 14.8016 15.7749 14.3873C15.1701 13.8223 14.9055 13.8223 14.3133 14.4124C13.9731 14.7513 13.6204 15.0778 13.2298 15.354C11.9068 16.3081 10.7098 16.2453 9.47504 15.1907C9.28604 15.0275 9.10965 14.8518 8.94585 14.6635C8.10167 13.6968 7.92527 13.6968 7.08109 14.7011C5.93451 16.057 4.48554 16.3583 2.87277 15.6301C2.24278 15.3414 2.00339 14.902 2.06639 14.2492C2.10419 13.9353 2.14199 13.6215 2.10419 13.3201C1.88999 11.776 3.13737 10.621 4.75013 10.6335C8.16467 10.6712 11.5918 10.6461 15.0315 10.6461Z"
                                            fill="#D94B2B" />
                                        <path
                                            d="M27.7321 21.606C19.2525 21.606 10.8107 21.606 2.33105 21.606C2.33105 20.2878 2.33105 18.9696 2.33105 17.6012C4.43521 18.3042 6.27478 17.8522 7.78675 16.2327C10.3067 18.6432 12.625 18.3168 15.0568 16.1574C18.0681 18.7687 20.2353 18.1661 22.2891 16.1198C22.982 16.8605 23.738 17.5384 24.7712 17.802C25.7918 18.0657 26.7494 17.8522 27.7573 17.4254C27.7321 18.8315 27.7321 20.1874 27.7321 21.606Z"
                                            fill="#D94B2B" />
                                        <path
                                            d="M13.2297 9.46596C13.2297 8.22308 13.2171 7.00531 13.2423 5.77499C13.2549 5.37325 13.5447 5.13472 13.9605 5.13472C14.6535 5.12217 15.3465 5.12217 16.0269 5.13472C16.5056 5.13472 16.7828 5.41092 16.7828 5.87542C16.808 7.05553 16.7954 8.24819 16.7954 9.46596C15.5985 9.46596 14.4393 9.46596 13.2297 9.46596Z"
                                            fill="#D94B2B" />
                                        <path
                                            d="M15.0188 0C15.3212 0.55239 15.674 1.18011 16.0142 1.82038C16.1654 2.10913 16.367 2.39788 16.4552 2.71173C16.6442 3.40222 16.3418 4.15548 15.8 4.45678C15.2582 4.75809 14.4266 4.67021 13.9856 4.26847C13.5194 3.82907 13.3682 2.98793 13.6958 2.37277C14.1242 1.54418 14.5904 0.740705 15.0188 0Z"
                                            fill="#D94B2B" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_681_16526">
                                            <rect width="30" height="26" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <p class="mb-0 text-secondary fs-6 fw-5">12th June, 1990</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="contact-box d-flex align-items-center">
                            <div class="contact-icon d-flex justify-content-center align-items-center me-3">
                                <svg width="20" height="26" viewBox="0 0 20 26" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_681_16532)">
                                        <path
                                            d="M9.99348 21.3252C9.65861 20.9328 9.33688 20.5606 9.02171 20.185C7.32112 18.1393 5.71245 16.0232 4.32046 13.7462C3.69341 12.7233 3.14515 11.6603 2.67568 10.5502C1.81225 8.50122 1.95999 6.48574 2.91206 4.53398C4.14318 2.01212 6.16222 0.509733 8.89368 0.0905402C13.0959 -0.55334 17.088 2.45814 17.7742 6.71378C17.9974 8.10886 17.784 9.41674 17.2489 10.6978C16.6514 12.1264 15.8799 13.4544 15.0394 14.7388C13.5391 17.0259 11.8615 19.1688 10.0756 21.2279C10.0559 21.2514 10.0329 21.2782 9.99348 21.3252ZM13.9429 7.37108C13.9462 5.15103 12.1734 3.34347 9.99676 3.34347C7.81685 3.34347 6.04732 5.14768 6.04732 7.36772C6.04732 9.58777 7.81685 11.3953 9.99348 11.3953C12.1701 11.3953 13.9396 9.59447 13.9429 7.37108Z"
                                            fill="#D94B2B" />
                                        <path
                                            d="M6.92352 18.592C6.54269 18.649 6.16515 18.7027 5.79088 18.7698C4.66153 18.9676 3.55517 19.246 2.51117 19.7457C2.10408 19.9435 1.71669 20.1716 1.39824 20.5036C0.886091 21.0401 0.886091 21.5901 1.41137 22.1166C1.85786 22.566 2.41268 22.8276 2.98721 23.0556C4.10014 23.4916 5.26232 23.7297 6.44092 23.8906C8.066 24.1153 9.70093 24.169 11.3391 24.0885C13.1743 23.9979 14.9898 23.7632 16.7397 23.1529C17.2584 22.9718 17.764 22.7571 18.2105 22.4218C18.4107 22.2709 18.6044 22.0965 18.7587 21.8986C19.0575 21.5163 19.0673 21.0904 18.7587 20.7182C18.5486 20.4633 18.2892 20.2319 18.0135 20.0508C17.242 19.5444 16.3753 19.256 15.4888 19.0481C14.7535 18.8771 14.0082 18.7664 13.2663 18.6289C13.2006 18.6155 13.1382 18.6054 13.0726 18.5954C13.194 18.3338 13.217 18.3271 13.4829 18.3472C14.5795 18.4344 15.6727 18.5551 16.7462 18.8C17.3306 18.9307 17.9084 19.0884 18.437 19.3734C18.7686 19.5511 19.0969 19.7591 19.3693 20.0139C20.0686 20.6712 20.1934 21.5834 19.7469 22.4419C19.5072 22.9047 19.156 23.2702 18.7554 23.5888C17.8822 24.283 16.8874 24.7424 15.8434 25.0945C13.6471 25.8357 11.3851 26.0805 9.08045 25.9799C7.31091 25.8994 5.58077 25.6076 3.90645 24.9973C2.87559 24.6217 1.89397 24.1522 1.05352 23.4144C0.685829 23.0925 0.373944 22.7169 0.176964 22.2575C-0.154618 21.4828 -0.00360029 20.6645 0.57749 20.0642C1.06337 19.5612 1.67729 19.2829 2.31748 19.0649C3.19404 18.7664 4.10014 18.6122 5.01281 18.4981C5.5184 18.4344 6.02398 18.3975 6.53284 18.3439C6.77907 18.3204 6.79876 18.3338 6.92352 18.592Z"
                                            fill="#D94B2B" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_681_16532">
                                            <rect width="20" height="26" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <div class="contact-desc">
                                <p class="text-secondary mb-0 fs-6 fw-5">New York, USA</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="our-services-section pt-60 px-30">
                <div class="services-bg-img">
                    <img src="{{ asset('assets/img/vcard31/services-bg.png') }}" alt="services-bg" />
                </div>
                <div class="section-heading">
                    <h2 class="mb-0">Our Services</h2>
                </div>
                <div class="services">
                    <div class="row">
                        <div class="col-sm-6 mb-sm-0 mb-40">
                            <div class="service-card h-100">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="card-img d-flex justify-content-center align-items-center">
                                        <svg width="30" height="28" viewBox="0 0 30 28" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M25.6055 1.74999H22.0898C21.6045 1.74999 21.2109 2.14175 21.2109 2.62499V5.10235L15.5774 0.215294C15.2465 -0.0717646 14.7535 -0.0717646 14.4226 0.215294C14.128 0.470852 0.934921 11.9158 0.301524 12.4653C-0.0644512 12.7828 -0.102596 13.3355 0.216271 13.6999C0.535196 14.0642 1.09037 14.1021 1.45635 13.7847L1.75787 13.5232V27.125C1.75787 27.6082 2.15138 28 2.63677 28H27.3633C27.8487 28 28.2422 27.6082 28.2422 27.125V13.5232L28.5437 13.7847C28.9097 14.1022 29.4649 14.0642 29.7837 13.6999C30.1026 13.3355 30.0645 12.7828 29.6985 12.4653C29.5892 12.3701 26.8111 9.96052 26.4844 9.67702V2.62499C26.4844 2.14175 26.0908 1.74999 25.6055 1.74999ZM22.9687 3.49999H24.7266V8.15213L22.9687 6.62724V3.49999ZM14.1211 26.25V19.8035C14.1211 19.4332 13.887 19.1031 13.5366 18.979C11.7834 18.3585 10.6055 16.7093 10.6055 14.875C10.6055 13.4889 11.2781 12.2085 12.3633 11.3977V14.875C12.3633 15.107 12.4559 15.3296 12.6208 15.4937L14.3786 17.2437C14.7218 17.5854 15.2783 17.5854 15.6215 17.2437L17.3793 15.4937C17.5442 15.3296 17.6367 15.107 17.6367 14.875V11.3874C18.7574 12.2021 19.4531 13.4886 19.4531 14.875C19.4531 16.6969 18.2517 18.3461 16.4635 18.979C16.1131 19.1031 15.8789 19.4332 15.8789 19.8035V26.25H14.1211ZM26.4844 26.25H17.6367V20.3881C19.798 19.3737 21.2109 17.2296 21.2109 14.875C21.2109 12.3143 19.5397 10.0024 17.0522 9.12204C16.7832 9.02684 16.4844 9.06767 16.251 9.23165C16.0177 9.39562 15.8789 9.66221 15.8789 9.94652V14.5126L15 15.3876L14.1211 14.5126V9.94652C14.1211 9.66221 13.9823 9.39562 13.749 9.23165C13.5157 9.06767 13.2169 9.0269 12.9478 9.12204C10.4954 9.98998 8.84769 12.3019 8.84769 14.875C8.84769 17.2378 10.2372 19.3804 12.3633 20.3869V26.25H3.51568V11.9982L15 2.03559L26.4844 11.9983V26.25Z"
                                                fill="#D94B2B" />
                                        </svg>
                                    </div>
                                    <span class="text-gray-100 mx-4">|</span>
                                    <h4 class="card-title fs-6 text-secondary mb-0">
                                        Home Repair
                                    </h4>
                                </div>
                                <div class="card-body p-0">
                                    <p class="mb-0 fs-14 text-gray-100">
                                        If you are going to use a passage of Lorem Ipsum, you need
                                        to be sure there isn't anything embarrassing hidden in the
                                        middle of text.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="service-card h-100">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="card-img d-flex justify-content-center align-items-center">
                                        <svg width="30" height="26" viewBox="0 0 30 26" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M3.225 13.6942H26.7797C27.6334 13.6929 28.4518 13.3507 29.0554 12.7426C29.6591 12.1345 29.9988 11.3101 30 10.4501V3.24882C30 2.388 29.6609 1.56236 29.0571 0.953225C28.4533 0.344089 27.6342 0.0012512 26.7797 0H3.225C2.36968 0 1.54939 0.342285 0.944581 0.951557C0.339776 1.56083 0 2.38718 0 3.24882L0 10.4501C0.00124202 11.3109 0.341566 12.136 0.946236 12.7443C1.55091 13.3525 2.37049 13.6942 3.225 13.6942ZM1.875 3.24882C1.875 2.88813 2.01723 2.54222 2.27041 2.28717C2.52358 2.03213 2.86696 1.88885 3.225 1.88885H26.7797C27.1369 1.8901 27.4791 2.03393 27.7313 2.28884C27.9834 2.54375 28.125 2.88895 28.125 3.24882V10.4501C28.1238 10.8091 27.9816 11.1531 27.7296 11.407C27.4776 11.6609 27.1361 11.8041 26.7797 11.8053H3.225C2.86777 11.8053 2.5251 11.6627 2.27206 11.4086C2.01902 11.1546 1.87624 10.8099 1.875 10.4501V3.24882Z"
                                                fill="#D94B2B" />
                                            <path
                                                d="M5.85938 10.3887H24.1406C24.3893 10.3887 24.6277 10.2892 24.8035 10.112C24.9794 9.93494 25.0781 9.69472 25.0781 9.44424C25.0781 9.19376 24.9794 8.95355 24.8035 8.77643C24.6277 8.59932 24.3893 8.49982 24.1406 8.49982H5.85938C5.61073 8.49982 5.37228 8.59932 5.19646 8.77643C5.02065 8.95355 4.92188 9.19376 4.92188 9.44424C4.92188 9.69472 5.02065 9.93494 5.19646 10.112C5.37228 10.2892 5.61073 10.3887 5.85938 10.3887Z"
                                                fill="#D94B2B" />
                                            <path
                                                d="M25.3125 4.7221C25.8303 4.7221 26.25 4.29927 26.25 3.77768C26.25 3.25609 25.8303 2.83325 25.3125 2.83325C24.7947 2.83325 24.375 3.25609 24.375 3.77768C24.375 4.29927 24.7947 4.7221 25.3125 4.7221Z"
                                                fill="#D94B2B" />
                                            <path
                                                d="M17.8125 14.8747C17.5639 14.8747 17.3254 14.9742 17.1496 15.1513C16.9738 15.3284 16.875 15.5686 16.875 15.8191V22.1845C16.8741 22.9386 17.0953 23.6761 17.5106 24.3035C17.9259 24.9309 18.5166 25.42 19.208 25.709C19.8994 25.998 20.6604 26.0739 21.3947 25.927C22.1289 25.7801 22.8033 25.4171 23.3327 24.8839C23.862 24.3506 24.2224 23.6712 24.3682 22.9315C24.514 22.1919 24.4387 21.4253 24.1518 20.7288C23.8649 20.0322 23.3793 19.4371 22.7565 19.0188C22.1337 18.6004 21.4017 18.3776 20.6531 18.3785C20.4045 18.3785 20.166 18.478 19.9902 18.6551C19.8144 18.8322 19.7156 19.0725 19.7156 19.3229C19.7156 19.5734 19.8144 19.8136 19.9902 19.9907C20.166 20.1679 20.4045 20.2674 20.6531 20.2674C21.0295 20.2674 21.3975 20.3798 21.7104 20.5905C22.0234 20.8011 22.2673 21.1005 22.4114 21.4509C22.5554 21.8012 22.5931 22.1867 22.5197 22.5586C22.4463 22.9305 22.265 23.2721 21.9988 23.5402C21.7327 23.8083 21.3936 23.9909 21.0244 24.0649C20.6552 24.1389 20.2726 24.1009 19.9248 23.9558C19.5771 23.8107 19.2799 23.5649 19.0707 23.2497C18.8616 22.9344 18.75 22.5637 18.75 22.1845V15.8191C18.75 15.5686 18.6512 15.3284 18.4754 15.1513C18.2996 14.9742 18.0611 14.8747 17.8125 14.8747Z"
                                                fill="#D94B2B" />
                                            <path
                                                d="M10.3129 15.8191V21.1457C10.3241 21.3433 10.2951 21.5412 10.2277 21.7272C10.1603 21.9131 10.056 22.0833 9.92104 22.2272C9.78609 22.3711 9.6234 22.4858 9.44293 22.5641C9.26246 22.6425 9.06801 22.6829 8.87148 22.6829C8.67496 22.6829 8.48051 22.6425 8.30004 22.5641C8.11957 22.4858 7.95687 22.3711 7.82193 22.2272C7.68698 22.0833 7.58262 21.9131 7.51524 21.7272C7.44787 21.5412 7.41888 21.3433 7.43008 21.1457C7.43008 20.8952 7.33131 20.655 7.15549 20.4779C6.97968 20.3007 6.74122 20.2012 6.49258 20.2012C6.24394 20.2012 6.00548 20.3007 5.82967 20.4779C5.65385 20.655 5.55508 20.8952 5.55508 21.1457C5.53831 21.595 5.61167 22.0431 5.77078 22.4631C5.92989 22.8832 6.17148 23.2667 6.48109 23.5905C6.7907 23.9143 7.16198 24.172 7.5727 24.3479C7.98343 24.5239 8.42516 24.6146 8.87148 24.6146C9.31781 24.6146 9.75954 24.5239 10.1703 24.3479C10.581 24.172 10.9523 23.9143 11.2619 23.5905C11.5715 23.2667 11.8131 22.8832 11.9722 22.4631C12.1313 22.0431 12.2047 21.595 12.1879 21.1457V15.8191C12.1879 15.5686 12.0891 15.3284 11.9133 15.1513C11.7375 14.9742 11.499 14.8747 11.2504 14.8747C11.0017 14.8747 10.7633 14.9742 10.5875 15.1513C10.4117 15.3284 10.3129 15.5686 10.3129 15.8191Z"
                                                fill="#D94B2B" />
                                            <path
                                                d="M13.5938 15.8191V20.069C13.5938 20.3195 13.6925 20.5597 13.8683 20.7368C14.0442 20.914 14.2826 21.0135 14.5312 21.0135C14.7799 21.0135 15.0183 20.914 15.1942 20.7368C15.37 20.5597 15.4688 20.3195 15.4688 20.069V15.8191C15.4688 15.5686 15.37 15.3284 15.1942 15.1513C15.0183 14.9742 14.7799 14.8747 14.5312 14.8747C14.2826 14.8747 14.0442 14.9742 13.8683 15.1513C13.6925 15.3284 13.5938 15.5686 13.5938 15.8191Z"
                                                fill="#D94B2B" />
                                        </svg>
                                    </div>
                                    <span class="text-gray-100 mx-4">|</span>
                                    <h4 class="card-title fs-6 text-secondary mb-0">
                                        AC Services
                                    </h4>
                                </div>
                                <div class="card-body p-0">
                                    <p class="mb-0 fs-14 text-gray-100">
                                        If you are going to use a passage of Lorem Ipsum, you need
                                        to be sure there isn't anything embarrassing hidden in the
                                        middle of text.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="appointment-section pt-60 px-30">
                <div class="appointment-bg-img text-end">
                    <img src="{{ asset('assets/img/vcard31/make-appointment-bg.png') }}" alt="appointment-bg" />
                </div>
                <div class="section-heading">
                    <h2 class="mb-0">Make an Appointment</h2>
                </div>
                <div class="appointment">
                    <form action="">
                        <div class="row justify-content-center">
                            <div class="col-12">
                                <div class="mb-20">
                                    <label class="text-secondary fs-6 fw-5 mb-1">Date :</label>
                                    <div class="position-relative">
                                        <input type="text" class="form-control appointment-input"
                                            placeholder="" />
                                        <span class="calendar-icon"><svg width="20" height="20"
                                                viewBox="0 0 20 20" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M6.25 9.375V10.625C6.25 10.9705 5.97047 11.25 5.625 11.25H4.375C4.02953 11.25 3.75 10.9705 3.75 10.625V9.375C3.75 9.02953 4.02953 8.75 4.375 8.75H5.625C5.97047 8.75 6.25 9.02953 6.25 9.375ZM5.625 13.75H4.375C4.02953 13.75 3.75 14.0295 3.75 14.375V15.625C3.75 15.9705 4.02953 16.25 4.375 16.25H5.625C5.97047 16.25 6.25 15.9705 6.25 15.625V14.375C6.25 14.0295 5.97047 13.75 5.625 13.75ZM10.625 8.75H9.375C9.02953 8.75 8.75 9.02953 8.75 9.375V10.625C8.75 10.9705 9.02953 11.25 9.375 11.25H10.625C10.9705 11.25 11.25 10.9705 11.25 10.625V9.375C11.25 9.02953 10.9705 8.75 10.625 8.75ZM10.625 13.75H9.375C9.02953 13.75 8.75 14.0295 8.75 14.375V15.625C8.75 15.9705 9.02953 16.25 9.375 16.25H10.625C10.9705 16.25 11.25 15.9705 11.25 15.625V14.375C11.25 14.0295 10.9705 13.75 10.625 13.75ZM15.625 8.75H14.375C14.0295 8.75 13.75 9.02953 13.75 9.375V10.625C13.75 10.9705 14.0295 11.25 14.375 11.25H15.625C15.9705 11.25 16.25 10.9705 16.25 10.625V9.375C16.25 9.02953 15.9705 8.75 15.625 8.75ZM15.625 13.75H14.375C14.0295 13.75 13.75 14.0295 13.75 14.375V15.625C13.75 15.9705 14.0295 16.25 14.375 16.25H15.625C15.9705 16.25 16.25 15.9705 16.25 15.625V14.375C16.25 14.0295 15.9705 13.75 15.625 13.75ZM4.375 3.75H5.625C5.97047 3.75 6.25 3.47047 6.25 3.125V0.625C6.25 0.279531 5.97047 0 5.625 0H4.375C4.02953 0 3.75 0.279531 3.75 0.625V3.125C3.75 3.47047 4.02953 3.75 4.375 3.75ZM20 5V17.5C20 18.8806 18.8806 20 17.5 20H2.5C1.11937 20 0 18.8806 0 17.5V5C0 3.61937 1.11937 2.5 2.5 2.5H3.125V3.125C3.125 3.81348 3.6859 4.375 4.375 4.375H5.625C6.3141 4.375 6.875 3.81348 6.875 3.125V2.5H13.125V3.125C13.125 3.81348 13.6865 4.375 14.375 4.375H15.625C16.3135 4.375 16.875 3.81348 16.875 3.125V2.5H17.5C18.8806 2.5 20 3.61937 20 5ZM18.75 7.5C18.75 6.81152 18.1897 6.25 17.5 6.25H2.5C1.8109 6.25 1.25 6.81152 1.25 7.5V17.5C1.25 18.1897 1.8109 18.75 2.5 18.75H17.5C18.1897 18.75 18.75 18.1897 18.75 17.5V7.5ZM14.375 3.75H15.625C15.9705 3.75 16.25 3.47047 16.25 3.125V0.625C16.25 0.279531 15.9705 0 15.625 0H14.375C14.0295 0 13.75 0.279531 13.75 0.625V3.125C13.75 3.47047 14.0295 3.75 14.375 3.75Z"
                                                    fill="#D94B2B" />
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                                <label class="text-secondary fs-6 fw-5 mb-1">Hour:</label>
                                <div class="row m-0">
                                    <div class="col-sm-3 px-sm-2 ps-sm-0 mb-3">
                                        <div class="hour-input d-flex justify-content-center align-items-center">
                                            <span class="text-secondary">8:10 - 20:00</span>
                                        </div>
                                    </div>
                                    <div class="col-sm-3 px-sm-2 mb-3">
                                        <div class="hour-input d-flex justify-content-center align-items-center">
                                            <span class="text-secondary">8:10 - 20:00</span>
                                        </div>
                                    </div>
                                    <div class="col-sm-3 px-sm-2 mb-3">
                                        <div class="hour-input d-flex justify-content-center align-items-center">
                                            <span class="text-secondary">8:10 - 20:00</span>
                                        </div>
                                    </div>
                                    <div class="col-sm-3 px-sm-2 pe-sm-0 mb-3">
                                        <div class="hour-input d-flex justify-content-center align-items-center">
                                            <span class="text-secondary">8:10 - 20:00</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-2 text-center">
                                    <button class="btn btn-primary w-100 rounded-2">
                                        Make an Appointment
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="gallery-section pt-60">
                <div class="section-heading px-30">
                    <h2 class="mb-0">Gallery</h2>
                </div>
                <div class="gallery-slider">
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="{{ asset('assets/img/vcard31/gallery-img1.png') }}" />
                        </div>
                    </div>
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="{{ asset('assets/img/vcard31/gallery-img2.png') }}" />
                        </div>
                    </div>
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="{{ asset('assets/img/vcard31/gallery-img3.png') }}" />
                        </div>
                    </div>
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="{{ asset('assets/img/vcard31/gallery-img1.png') }}" />
                        </div>
                    </div>
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="{{ asset('assets/img/vcard31/gallery-img2.png') }}" />
                        </div>
                    </div>
                    <div class="slide">
                        <div class="gallery-img">
                            <img src="{{ asset('assets/img/vcard31/gallery-img3.png') }}" />
                        </div>
                    </div>
                </div>
            </div>
            <div class="product-section pt-60 px-4">
                <div class="product-bg-img text-end">
                    <img src="{{ asset('assets/img/vcard31/product-bg.png') }}" alt="product-bg" />
                </div>
                <div class="section-heading px-2">
                    <h2 class="mb-0">Products</h2>
                </div>
                <div class="">
                    <div class="product-slider">
                        <div class="">
                            <div class="product-card card-1 card justify-content-end">
                                <div class="product-desc align-items-center">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <h3 class="text-secondary fs-6 fw-5 mb-0">Lorem Ipsum</h3>
                                        <h4 class="text-center text-primary mb-0 fs-6">$125</h4>
                                    </div>
                                    <p class="mb-0 text-gray-100 fs-12">
                                        It is a long established
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <div class="product-card card-2 card justify-content-end">
                                <div class="product-desc align-items-center">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <h3 class="text-secondary fs-6 fw-5 mb-0">Lorem Ipsum</h3>
                                        <h4 class="text-center text-primary mb-0 fs-6">$125</h4>
                                    </div>
                                    <p class="mb-0 text-gray-100 fs-12">
                                        It is a long established
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <div class="product-card card-1 card justify-content-end">
                                <div class="product-desc align-items-center">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <h3 class="text-secondary fs-6 fw-5 mb-0">Lorem Ipsum</h3>
                                        <h4 class="text-center text-primary mb-0 fs-6">$125</h4>
                                    </div>
                                    <p class="mb-0 text-gray-100 fs-12">
                                        It is a long established
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <div class="product-card card-2 card justify-content-end">
                                <div class="product-desc align-items-center">
                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                        <h3 class="text-secondary fs-6 fw-5 mb-0">Lorem Ipsum</h3>
                                        <h4 class="text-center text-primary mb-0 fs-6">$125</h4>
                                    </div>
                                    <p class="mb-0 text-gray-100 fs-12">
                                        It is a long established
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="testimonial-section pt-60">
                <div class="testimonial-bg-img text-end">
                    <img src="{{ asset('assets/img/vcard31/testimonial-bg.png') }}" alt="testimonial-bg" />
                </div>
                <div class="section-heading px-30">
                    <h2 class="mb-0">Testimonial</h2>
                </div>
                <div class="testimonial-slider">
                    <div class="px-30">
                        <div class="testimonial-card card">
                            <div class="testimonial-profile-img">
                                <img src="{{ asset('assets/img/vcard31/testimonial-profile-img.png') }}"
                                    class="w-100 h-100 object-fit-cover" />
                            </div>
                            <div class="card-body p-0 pt-5">
                                <div class="text-center">
                                    <h3 class="text-primary fs-20">Ronald Richards</h3>
                                    <p class="fs-14 text-secondary">Customer</p>
                                    <div class="quote-img text-center mb-3">
                                        <img src="{{ asset('assets/img/vcard31/quote-img.png') }}" class="mx-auto" />
                                    </div>
                                    <p class="desc text-gray-100 fs-14 mb-0">
                                        If you are going to use a passage of Lorem Ipsum, you need
                                        to be sure there isn't anything embarrassing hidden in the
                                        middle of text.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="px-30">
                        <div class="testimonial-card card">
                            <div class="testimonial-profile-img">
                                <img src="{{ asset('assets/img/vcard31/testimonial-profile-img.png') }}"
                                    class="w-100 h-100 object-fit-cover" />
                            </div>
                            <div class="card-body p-0 pt-5">
                                <div class="text-center">
                                    <h3 class="text-primary fs-20">Ronald Richards</h3>
                                    <p class="fs-14 text-secondary">Customer</p>
                                    <div class="quote-img text-center mb-3">
                                        <img src="{{ asset('assets/img/vcard31/quote-img.png') }}" class="mx-auto" />
                                    </div>
                                    <p class="desc text-gray-100 fs-14 mb-0">
                                        If you are going to use a passage of Lorem Ipsum, you need
                                        to be sure there isn't anything embarrassing hidden in the
                                        middle of text.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="blog-section pt-60 px-3">
                <div class="blog-bg-img text-end">
                    <img src="{{ asset('assets/img/vcard31/blog-bg.png') }}" alt="blog-bg" />
                </div>
                <div class="section-heading px-14">
                    <h2 class="mb-0">Blog</h2>
                </div>
                <div class="blog-slider">
                    <div class="">
                        <div class="blog-card">
                            <div class="blog-img mb-3">
                                <img src="{{ asset('assets/img/vcard31/blog-img1.png') }}" />
                            </div>
                            <div class="blog-desc">
                                <h3 class="text-primary fs-6 fw-5 mb-1">
                                    Prepare Your A/C Unit
                                </h3>
                                <p class="mb-0 text-gray-100 fs-14">
                                    Lorem Ipsum is simply dummy text of the printing and type
                                    setting industry.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="">
                        <div class="blog-card">
                            <div class="blog-img mb-3">
                                <img src="{{ asset('assets/img/vcard31/blog-img2.png') }}" />
                            </div>
                            <div class="blog-desc">
                                <h3 class="text-primary fs-6 fw-5 mb-1">
                                    The Best Time To Aquarium
                                </h3>
                                <p class="mb-0 text-gray-100 fs-14">
                                    Lorem Ipsum is simply dummy text of the printing and type
                                    setting industry.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="">
                        <div class="blog-card">
                            <div class="blog-img mb-3">
                                <img src="{{ asset('assets/img/vcard31/blog-img1.png') }}" />
                            </div>
                            <div class="blog-desc">
                                <h3 class="text-primary fs-6 fw-5 mb-1">
                                    Prepare Your A/C Unit
                                </h3>
                                <p class="mb-0 text-gray-100 fs-14">
                                    Lorem Ipsum is simply dummy text of the printing and type
                                    setting industry.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="business-hour-section pt-60">
                <div class="hour-bg-img">
                    <img src="{{ asset('assets/img/vcard31/hour-bg.png') }}" alt="hour-bg" />
                </div>
                <div class="px-30 pt-30 pb-30 bg-light">
                    <div class="section-heading">
                        <h2 class="mb-0">Business Hours</h2>
                    </div>
                    <div class="business-hours">
                        <div class="row justify-content-center">
                            <div class="col-sm-6 col-10 mb-3">
                                <div class="hour">
                                    <span>Sunday :</span>
                                    <span>08:10 - 20:00</span>
                                </div>
                            </div>
                            <div class="col-sm-6 col-10 mb-3">
                                <div class="hour">
                                    <span>Monday :</span>
                                    <span>08:10 - 20:00</span>
                                </div>
                            </div>
                            <div class="col-sm-6 col-10 mb-3">
                                <div class="hour">
                                    <span>Tuesday :</span>
                                    <span>08:10 - 20:00</span>
                                </div>
                            </div>
                            <div class="col-sm-6 col-10 mb-3">
                                <div class="hour">
                                    <span>Wednesday :</span>
                                    <span>08:10 - 20:00</span>
                                </div>
                            </div>
                            <div class="col-sm-6 col-10 mb-3">
                                <div class="hour">
                                    <span>Thursday :</span>
                                    <span>08:10 - 20:00</span>
                                </div>
                            </div>
                            <div class="col-sm-6 col-10 mb-3">
                                <div class="hour">
                                    <span>Friday :</span>
                                    <span>08:10 - 20:00</span>
                                </div>
                            </div>
                            <div class="col-sm-6 col-10">
                                <div class="hour">
                                    <span>Saturday :</span>
                                    <span>08:10 - 20:00</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="qr-code-section pt-60 px-30">
                <div class="qr-bg-img text-end">
                    <img src="{{ asset('assets/img/vcard31/qr-bg-img.png') }}" alt="qr-bg" />
                </div>
                <div class="section-heading">
                    <h2 class="mb-0">QR Code</h2>
                </div>
                <div class="row">
                    <div class="col-sm-7 mb-sm-0 mb-40">
                        <div class="qr-profile-img mb-3">
                            <img src="{{ asset('assets/img/vcard31/qr-profile-img.png') }}" class="w-100 h-100 object-fit-cover" />
                        </div>
                    </div>
                    <div class="col-sm-5">
                        <div class="qr-code-img mx-auto">
                            <img src="{{ asset('assets/img/vcard31/qr-code-img.png') }}" class="w-100 h-100 object-fit-cover" />
                        </div>
                    </div>
                </div>
            </div>
            <div class="contact-us-section pt-60 px-30">
                <div class="section-heading">
                    <h2 class="mb-0">Inquiries</h2>
                </div>
                <div class="contact-form">
                    <form action="">
                        <div class="row">
                            <div class="col-sm-6 mb-3">
                                <input type="text" class="form-control" placeholder="Full Name" />
                            </div>
                            <div class="col-sm-6 mb-3">
                                <input type="email" class="form-control" placeholder="Email Address" />
                            </div>
                            <div class="col-12 mb-3">
                                <input type="tel" class="form-control" placeholder="Phone Number" />
                            </div>
                            <div class="col-12 mb-3">
                                <textarea class="form-control h-100" placeholder="Your Message" rows="4"></textarea>
                            </div>
                            <div class="col-12 text-center pt-3">
                                <button class="btn btn-primary send-btn rounded-2" type="submit">
                                    Send Message
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="create-vcard-section">
                <div class="create-vcard-bg-img text-end">
                    <img src="{{ asset('assets/img/vcard31/create-vcard-bg.png') }}" alt="create-vcard-bg" />
                </div>
                <div class="add-to-contact-bg-img">
                    <img src="{{ asset('assets/img/vcard31/add-to-contact-bg.png') }}" alt="add-to-contact-bg" />
                </div>
                <div class="pt-60 pb-60">
                    <div class="section-heading mb-40 px-30">
                        <h2 class="mb-0">Create Your VCard</h2>
                    </div>
                    <div class="pb-60 mb-5">
                        <div class="vcard-link-card card">
                            <div class="d-flex align-items-center justify-content-center">
                                <a href="https://vcards.infyom.com/marlonbrasil"
                                    class="text-primary link-text fw-normal">https://vcards.infyom.com/marlonbrasil</a>
                                <i class="icon fa-solid fa-arrow-up-right-from-square ms-4 text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="add-to-contact-section pb-60">
                <div class="text-center">
                    <button class="btn btn-primary add-contact-btn rounded-2"><i
                        class="fas fa-download fa-address-book"></i>
                    &nbsp;Add to Contact</button>
                </div>
            </div>
        </div>
    </div>
</body>
@include('vcardTemplates.template.templates')
<script src="https://js.stripe.com/v3/"></script>
<script type="text/javascript" src="{{ asset('assets/js/front-third-party.js') }}"></script>
<script type="text/javascript" src="{{ asset('front/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('assets/js/slider/js/slick.min.js') }}" type="text/javascript"></script>
<script>
    $().ready(function() {
        $(".gallery-slider").slick({
            arrows: true,
            infinite: true,
            dots: false,
            slidesToShow: 2.3,
            autoplay: true,
            prevArrow: '<button class="slide-arrow prev-arrow"><i class="fa-solid fa-arrow-left"></i></button>',
            nextArrow: '<button class="slide-arrow next-arrow"><i class="fa-solid fa-arrow-right"></i></button>',
            responsive: [{
                    breakpoint: 768,
                    settings: {
                        slidesToShow: 2.15,
                        dots: false,
                    },
                },
                {
                    breakpoint: 575,
                    settings: {
                        dots: true,
                        slidesToShow: 1,
                    },
                },
            ],
        });
        $(".product-slider").slick({
            arrows: false,
            infinite: true,
            dots: false,
            slidesToShow: 2,
            slidesToScroll: 1,
            autoplay: true,
            vertical: false,
            responsive: [{
                breakpoint: 575,
                settings: {
                    slidesToShow: 1,
                    dots: true,
                },
            }, ],
        });
        $(".blog-slider").slick({
            arrows: false,
            infinite: true,
            dots: true,
            slidesToShow: 2,
            slidesToScroll: 1,
            autoplay: true,
            responsive: [{
                breakpoint: 575,
                settings: {
                    slidesToShow: 1,
                    dots: true,
                },
            }, ],
        });
        $(".testimonial-slider").slick({
            arrows: true,
            infinite: true,
            dots: false,
            slidesToShow: 1,
            slidesToScroll: 1,
            autoplay: true,
            prevArrow: '<button class="slide-arrow prev-arrow"><i class="fa-solid fa-arrow-left"></i></button>',
            nextArrow: '<button class="slide-arrow next-arrow"><i class="fa-solid fa-arrow-right"></i></button>',
            responsive: [{
                breakpoint: 575,
                settings: {
                    arrows: false,
                    dots: true,
                },
            }, ],
        });
    });
</script>
<script>
    $("#myID").flatpickr();
</script>

<script>
    $(document).ready(function() {
        $('.dropdown1').hover(function() {
            $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeIn(100);
        }, function() {
            $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeOut(100);
        });
    });
</script>

</html>
